<?php
/**
 * Astra child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_ASTRA_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_ASTRA_CHILD_VERSION, 'all' );

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

/*home blog post*/
function astra_latest_blogs() {
    ob_start();
    $args = array(
        'posts_per_page' => 3,
        'post_status'    => 'publish'
    );
    $latest_posts = new WP_Query($args);

    if ($latest_posts->have_posts()) :
        echo '<div class="astra-blog-wrapper">';
        while ($latest_posts->have_posts()) : $latest_posts->the_post(); ?>
            
            <div class="astra-blog-card">
                <?php if (has_post_thumbnail()) : ?>
                    <div class="astra-post-thumbnail">
                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('large'); ?></a>
                    </div>
                <?php endif; ?>
                
                <div class="astra-post-content">
                    <h3 class="astra-post-title"><?php the_title(); ?></h3>
                    <p class="astra-post-excerpt"><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                    <a class="button outlined" href="<?php the_permalink(); ?>">READ MORE</a>
                </div>
            </div>

        <?php endwhile;
        echo '</div>';
        wp_reset_postdata();
    endif;

    return ob_get_clean();
}
add_shortcode('latest_blogs', 'astra_latest_blogs');
add_filter('use_block_editor_for_post', '__return_false', 10);
